Ext.data.JsonP.sol_common_XmlUtils({"tagname":"class","name":"sol.common.XmlUtils","autodetected":{"aliases":true,"alternateClassNames":true,"extends":true,"mixins":true,"requires":true,"uses":true,"members":true,"code_type":true,"singleton":true},"files":[{"filename":"lib_sol.common.XmlUtils.js","href":"lib_sol.common.XmlUtils.html#sol-common-XmlUtils"}],"author":[{"tagname":"author","name":"Michael Weiler, ELO Digital Office GmbH","email":null}],"version":["1.0"],"elojc":true,"eloas":true,"eloix":true,"aliases":{},"alternateClassNames":[],"extends":"sol.Base","mixins":[],"requires":[],"uses":[],"members":[{"name":"requiredConfig","tagname":"cfg","owner":"sol.Base","id":"cfg-requiredConfig","meta":{"protected":true}},{"name":"$className","tagname":"property","owner":"sol.Base","id":"property-S-className","meta":{"protected":true}},{"name":"logger","tagname":"property","owner":"sol.Base","id":"property-logger","meta":{"protected":true}},{"name":"$super","tagname":"method","owner":"sol.Base","id":"method-S-super","meta":{"private":true}},{"name":"convertObjectToXml","tagname":"method","owner":"sol.common.XmlUtils","id":"method-convertObjectToXml","meta":{}},{"name":"getAttributes","tagname":"method","owner":"sol.common.XmlUtils","id":"method-getAttributes","meta":{}},{"name":"initialize","tagname":"method","owner":"sol.Base","id":"method-initialize","meta":{"private":true}},{"name":"readXmlFile","tagname":"method","owner":"sol.common.XmlUtils","id":"method-readXmlFile","meta":{}},{"name":"toString","tagname":"method","owner":"sol.common.XmlUtils","id":"method-toString","meta":{}}],"code_type":"ext_define","singleton":true,"id":"class-sol.common.XmlUtils","classIcon":"icon-singleton","superclasses":["sol.Base"],"subclasses":[],"mixedInto":[],"parentMixins":[],"html":"<div><pre class=\"hierarchy\"><h4>Hierarchy</h4><div class='subclass first-child'><a href='#!/api/sol.Base' rel='sol.Base' class='docClass'>sol.Base</a><div class='subclass '><strong>sol.common.XmlUtils</strong></div></div><h4>Files</h4><div class='dependency'><a href='source/lib_sol.common.XmlUtils.html#sol-common-XmlUtils' target='_blank'>lib_sol.common.XmlUtils.js</a></div></pre><div class='doc-contents'><p>XML Builder</p>\n      <p class='version-tag'>Version: <b>1.0</b></p>\n</div><div class='members'><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-cfg'>Config options</h3><div class='subsection'><div id='cfg-requiredConfig' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-cfg-requiredConfig' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-cfg-requiredConfig' class='name expandable'>requiredConfig</a> : Array<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>List of required config properties. ...</div><div class='long'><p>List of required config properties. <a href=\"#!/api/sol.Base-method-initialize\" rel=\"sol.Base-method-initialize\" class=\"docClass\">sol.Base.initialize</a> throws an exception if one of the properties is null or undefined.</p>\n</div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-property'>Properties</h3><div class='subsection'><div id='property-S-className' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-property-S-className' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-property-S-className' class='name expandable'>$className</a> : Object<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'><p>{String}\nname of the class including its namespace.</p>\n</div><div class='long'><p>{String}\nname of the class including its namespace.</p>\n</div></div></div><div id='property-logger' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-property-logger' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-property-logger' class='name expandable'>logger</a> : <a href=\"#!/api/sol.Logger\" rel=\"sol.Logger\" class=\"docClass\">sol.Logger</a><span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>Logger for this class instance. ...</div><div class='long'><p>Logger for this class instance. This logger is created by <a href=\"#!/api/sol.Base-method-initialize\" rel=\"sol.Base-method-initialize\" class=\"docClass\">sol.Base.initialize</a>.</p>\n\n<p>Please see <a href=\"#!/api/sol.Logger\" rel=\"sol.Logger\" class=\"docClass\">sol.Logger</a> class documentation for more information.</p>\n</div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-method'>Methods</h3><div class='subsection'><div id='method-S-super' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-method-S-super' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-method-S-super' class='name expandable'>$super</a>( <span class='pre'>superClassName, functionName, arguments</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Calls a function of a superclass thanks to its name. ...</div><div class='long'><p>Calls a function of a superclass thanks to its name. Superclass must be part of the calling objects class hierarchy.</p>\n\n<p><b>Please note that calling superclass functions might lead to an infinitive loop if misused. Please validate that none class other than the classes superclass is passed as the superclass parent.</b></p>\n\n<pre><code>me.$super(superClassName, functionName, attributesArray);\n</code></pre>\n\n<p>A basic example of the initialize-function will look as followed.</p>\n\n<pre><code>me.$super(\"<a href=\"#!/api/sol.Base\" rel=\"sol.Base\" class=\"docClass\">sol.Base</a>\", \"initialize\", [config]);\nme.$super(\"<a href=\"#!/api/sol.Base\" rel=\"sol.Base\" class=\"docClass\">sol.Base</a>\", \"initialize\", arguments);\n</code></pre>\n\n<p>A word on performance: The superclass name must be passed since the js rhino engine does not allow accessing the caller of the callee due to performance reasons.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>superClassName</span> : String<div class='sub-desc'><p>name of the super class.</p>\n</div></li><li><span class='pre'>functionName</span> : String<div class='sub-desc'><p>name of the function that should be called.</p>\n</div></li><li><span class='pre'>arguments</span> : Object[]<div class='sub-desc'><p>list of arguments that should be passed to the function.</p>\n</div></li></ul></div></div></div><div id='method-convertObjectToXml' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.XmlUtils'>sol.common.XmlUtils</span><br/><a href='source/lib_sol.common.XmlUtils.html#sol-common-XmlUtils-method-convertObjectToXml' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.XmlUtils-method-convertObjectToXml' class='name expandable'>convertObjectToXml</a>( <span class='pre'>data, dataDefinition</span> ) : org.w3c.dom.Document<span class=\"signature\"></span></div><div class='description'><div class='short'>Converts a JavaScript object to a XML document ...</div><div class='long'><p>Converts a JavaScript object to a XML document</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>data</span> : Object<div class='sub-desc'><p>Data object that contains the data that should be converted into XML</p>\n</div></li><li><span class='pre'>dataDefinition</span> : Object<div class='sub-desc'><p>Definition object that contains meta information for the transformation.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>org.w3c.dom.Document</span><div class='sub-desc'><p>XML document</p>\n\n<h2>Example</h2>\n\n<p>   // Each array element of the \"ChildSordDataCollector\" array should be converted\n   //   to tags with the tag name \"Sord\"\n   var dataDefinition = {\n     ChildSordDataCollector: \"Sord\"\n   }\n   var xmlDoc = <a href=\"#!/api/sol.common.XmlUtils-method-convertObjectToXml\" rel=\"sol.common.XmlUtils-method-convertObjectToXml\" class=\"docClass\">sol.common.XmlUtils.convertObjectToXml</a>({\n     ChildSordDataCollector: [{\n       name: \"Sord1\"\n     } , {\n       name: \"Sord2\"\n     }]\n   }, dataDefintion);\n   XML result:\n     <ChildSordDataCollector>\n       <Sord>\n         <name>Sord1</name>\n       </Sord>#\n       <Sord>\n         <name>Sord2</name>\n       </Sord>\n     </ChildSordDataCollector></p>\n</div></li></ul></div></div></div><div id='method-getAttributes' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.XmlUtils'>sol.common.XmlUtils</span><br/><a href='source/lib_sol.common.XmlUtils.html#sol-common-XmlUtils-method-getAttributes' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.XmlUtils-method-getAttributes' class='name expandable'>getAttributes</a>( <span class='pre'>xmlElement</span> ) : Object<span class=\"signature\"></span></div><div class='description'><div class='short'>Returns the attributes ...</div><div class='long'><p>Returns the attributes</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>xmlElement</span> : org.w3c.dom.Element<div class='sub-desc'><p>XML element</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'><p>Attributes object</p>\n</div></li></ul></div></div></div><div id='method-initialize' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-method-initialize' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-method-initialize' class='name expandable'>initialize</a>( <span class='pre'>config</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Initialize class. ...</div><div class='long'><p>Initialize class.\nThis function is called after the class was instantiated.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>config</span> : Object<div class='sub-desc'><p>parameters as defined. See documentation for more details.</p>\n</div></li></ul></div></div></div><div id='method-readXmlFile' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.XmlUtils'>sol.common.XmlUtils</span><br/><a href='source/lib_sol.common.XmlUtils.html#sol-common-XmlUtils-method-readXmlFile' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.XmlUtils-method-readXmlFile' class='name expandable'>readXmlFile</a>( <span class='pre'>xmlFilePath, params</span> ) : org.w3c.dom.Document<span class=\"signature\"></span></div><div class='description'><div class='short'>Reads a XML file ...</div><div class='long'><p>Reads a XML file</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>xmlFilePath</span> : String<div class='sub-desc'><p>XML file path</p>\n</div></li><li><span class='pre'>params</span> : Object<div class='sub-desc'><p>Parameters</p>\n<ul><li><span class='pre'>namespaceAware</span> : Boolean (optional)<div class='sub-desc'><p>Namespace aware</p>\n<p>Defaults to: <code>false</code></p></div></li></ul></div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>org.w3c.dom.Document</span><div class='sub-desc'><p>XML document</p>\n</div></li></ul></div></div></div><div id='method-toString' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.XmlUtils'>sol.common.XmlUtils</span><br/><a href='source/lib_sol.common.XmlUtils.html#sol-common-XmlUtils-method-toString' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.XmlUtils-method-toString' class='name expandable'>toString</a>( <span class='pre'>xmlDoc</span> ) : String<span class=\"signature\"></span></div><div class='description'><div class='short'>Returns the string representation of a XML document ...</div><div class='long'><p>Returns the string representation of a XML document</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>xmlDoc</span> : org.w3c.dom.Document<div class='sub-desc'><p>XML document</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'><p>String representation</p>\n</div></li></ul></div></div></div></div></div></div></div>","meta":{"eloas":true,"eloix":true,"elojc":true,"singleton":true}});